/*
 * CRfePurRM4RfSettings.h
 *
 *  Created on: 12.12.2011
 *      Author: stefan.detter
 */

#ifndef CRFEPURRM4RFSETTINGS_H_
#define CRFEPURRM4RFSETTINGS_H_

#include <QObject>
#include <QrfeTraceModule>
#include "../ui/ConfigDialog.h"

#include <QCheckBox>

class QrfeRfePurRM4Reader;
class QrfeProgressDialog;

namespace Ui
{
	class CRfePurRM4DialogClass;
};

typedef struct {
	QList<uint> 	frequencyList;
	uchar 			freqeuncyMaximum;
	uchar 			frequencyMode;

	ushort 			uhfMaxAttenuation;
	ushort 			uhfAttenuation;

	uchar 			rfLinkProfile;

    uchar           session;
    uchar           target;
    uchar           selectionFlag;
    bool            phaseValue;
} RF_SETTINGS;


class CRfePurRM4RfSettings : public QObject, ConfigDialog, QrfeTraceModule
{
	Q_OBJECT
public:
    CRfePurRM4RfSettings(Ui::CRfePurRM4DialogClass* dialog, QWidget* parent);
	virtual ~CRfePurRM4RfSettings();

    bool init (QrfeRfePurRM4Reader *reader, QrfeProgressDialog* pb );

//public slots:
//	bool writeSettings ( );
//	void reloadSettings ( );

private:
	void loadRfSettings ( );
	bool canReadAntennaSpec ( );
	void readAntennaSpec ( );

private slots:
	void loadFrequencyProfileTable();
	void addFrequencyEntry();
	void insertInFrequencyTable(bool checked, double frequency);
	QList<uint> readFreqeuncyTable();

	void setAttenuationLabel ( int value );

public:
	bool writeSettingsToReader( QrfeProgressDialog* pb);
	bool readSettingsFromReader( QrfeProgressDialog* pb);

private:
    Ui::CRfePurRM4DialogClass*		m_ui;
    QWidget*                		m_parent;
    QrfeRfePurRM4Reader* 			m_reader;

	RF_SETTINGS				m_settings;

	QList<QCheckBox*>		m_frequencyCheckBoxes;

	short					m_sensitivityOffset;

	QMap<double, bool>		m_userDefinedFrequencies;
    QMap<double, bool>		m_etsiFrequencies;
    QMap<double, bool>		m_etsiUpperFrequencies;
    QMap<double, bool>		m_fcc25Frequencies;
	QMap<double, bool>		m_fcc50Frequencies;
	QMap<double, bool>		m_japanFrequencies;
	QMap<double, bool>		m_currentFrequencies;
};

#endif /* CRFEPURRM4RFSETTINGS_H_ */
